package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.commit.graph.*;

import javax.annotation.Nonnull;

/**
 * A callback which can be used during a traverse of the nodes within a commit graph.
 *
 * @see ScmBulkContentCommandFactory#traverseCommits(BulkTraverseCommitsCommandParameters, BulkTraversalCallback)
 * @since 5.11
 */
@FunctionalInterface
public interface BulkTraversalCallback {

    /**
     * Receive a summary of the traversal when it has completed.
     *
     * @param summary summary of the traversal
     */
    default void onEnd(@Nonnull BulkTraversalSummary summary) {
    }

    /**
     * Visit a node in the commit graph. All commits are guaranteed to be visited in topological order:
     * that is children will be visited before parents within the graph.
     *
     * @param node the current node being traversed
     * @return the status of the traversal after visiting the node. If traversal is
     *         {@link BulkTraversalStatus#FINISH complete} this method will not be invoked again.
     */
    BulkTraversalStatus onNode(@Nonnull CommitGraphNode node);

    default void onStart(@Nonnull BulkTraversalContext context) {
    }
}
