package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Summarizes the results of a bulk content command.
 *
 * @since 4.2
 */
public class BulkContentSummary extends AbstractSummary {

    private BulkContentSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, BulkContentSummary> {

        /**
         * Creates and initializes a new builder by copying details from the provided summary.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public BulkContentSummary build() {
            return new BulkContentSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
