package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown by the {@link ScmService} to indicate none of the installed plugins supports the requested SCM.
 *
 * @see UnavailableScmException
 */
public class UnsupportedScmException extends ScmException {

    public UnsupportedScmException(@Nonnull KeyedMessage message, @Nonnull String scmId) {
        super(message, scmId);
    }
}
