package com.atlassian.bitbucket.scm;

import com.atlassian.utils.process.InputHandler;

/**
 * Describes an {@code InputHandler} which provides data to the standard input stream for a {@link Command} to process.
 * <p>
 * The format of data a command expects to receive on standard input, if any, is highly command-specific. As a result,
 * nothing about the format of the data provided by this handler is proscribed by this interface; instead, it is left
 * to the implementor to understand the needs of the command they are executing and provide appropriate input.
 */
public interface CommandInputHandler extends InputHandler {
}
