package com.atlassian.bitbucket.repository;

import javax.annotation.Nullable;

/**
 * A {@link Ref} denoting a tag in the repository.
 */
public interface Tag extends Ref {

    /**
     * The hash for the tag itself. Where {@link #getLatestCommit()} returns the hash of the tagged element, this
     * property provides the hash for the tag.
     *
     * @return the tag's hash
     */
    @Nullable
    String getHash();
}
