package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.commit.Commit;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * @since 5.10
 */
public interface RefChangeDetails {

    /**
     * Returns a list of commits associated with this {@link RefChangeDetails}. This may not contain every associated commit. Use {@link #getTotal()} to get the total number of commits.
     *
     * @return commits associated with this {@link RefChangeDetails}
     */
    @Nonnull
    List<Commit> getCommits();

    /**
     * Returns the total number of commits associated with this {@link RefChangeDetails}. This may be larger than the size of {@link #getCommits()}.
     *
     * @return the total number of commits associated with this {@link RefChangeDetails}
     */
    int getTotal();
}