package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates no tag exists with the specified name.
 */
public class NoSuchTagException extends NoSuchEntityException {

    private final String tagId;

    public NoSuchTagException(KeyedMessage keyedMessage, String tagId) {
        super(keyedMessage);
        this.tagId = tagId;
    }

    /**
     * Retrieves the missing tag ID.
     *
     * @return the tag ID
     */
    public String getTagId() {
        return tagId;
    }
}
