package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

public class ForkingDisabledException extends FeatureDisabledException {

    private final Repository repository;

    public ForkingDisabledException(@Nonnull KeyedMessage message, @Nonnull Repository repository) {
        super(message);

        this.repository = checkNotNull(repository, "repository");
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
