package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import java.util.SortedMap;
import java.util.function.Function;

public class SimplePullRequestActivityPage<T extends PullRequestActivity> implements PullRequestActivityPage<T> {

    private final Page<T> page;
    private final long previousPageStartId;

    public SimplePullRequestActivityPage(Page<T> page, long previousPageStartId) {
        this.page = page;
        this.previousPageStartId = previousPageStartId;
    }

    public boolean getIsFirstPage() {
        return previousPageStartId == NO_ID;
    }

    @Override
    public long getPreviousPageStartId() {
        return previousPageStartId;
    }

    @Override
    public int getStart() {
        return page.getStart();
    }

    @Override
    public int getSize() {
        return page.getSize();
    }

    @Override
    public int getLimit() {
        return page.getLimit();
    }

    @Override
    public boolean getIsLastPage() {
        return page.getIsLastPage();
    }

    @Nonnull
    @Override
    public Iterable<T> getValues() {
        return page.getValues();
    }

    @Override
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        return page.getOrdinalIndexedValues();
    }

    @Override
    public PageRequest getNextPageRequest() {
        return page.getNextPageRequest();
    }

    @Nonnull
    @Override
    public <E> Page<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        return page.transform(transformFunction);
    }
}
