package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

/**
 * A {@link PullRequestActivity} added when the source or target ref of the pull request moves.
 * <p>
 * <em>Note</em>: Rescope activities not adding or removing commits are pruned. Hence, not all source or target ref
 * moves will have a rescope activity.
 *
 * @see PullRequestActivityType#RESCOPE
 */
public interface PullRequestRescopeActivity extends PullRequestActivity {

    @Nonnull
    RescopeDetails getAdded();

    @Nonnull
    String getFromHash();

    @Nonnull
    String getPreviousFromHash();

    @Nonnull
    String getPreviousToHash();

    @Nonnull
    RescopeDetails getRemoved();

    @Nonnull
    String getToHash();
}
