package com.atlassian.bitbucket.pull;

import javax.annotation.Nonnull;

/**
 * Enumerates all the possible statuses a participant can have with regards to a pull request.
 *
 * @see PullRequestParticipant
 * @since 4.2
 */
public enum PullRequestParticipantStatus {

    /**
     * Indicates that the participant has not finished reviewing the changes in the pull request.
     */
    UNAPPROVED(0, 100),

    /**
     * Indicates that the participant has finished reviewing the changes in the pull request.
     * They have provided feedback which needs to be addressed before they can approve.
     */
    NEEDS_WORK(2, 200),

    /**
     * Indicates that the reviewer has approved the changes in the pull request.
     */
    APPROVED(1, 300);

    private final int id;

    /**
     * @since 4.4
     **/
    private final int weight;

    PullRequestParticipantStatus(int id, int weight) {
        this.id = id;
        this.weight = weight;
    }

    @Nonnull
    public static PullRequestParticipantStatus fromId(int id) {
        for (PullRequestParticipantStatus value : values()) {
            if (value.getId() == id) {
                return value;
            }
        }
        throw new IllegalArgumentException("No PullRequestParticipantStatus is associated with ID [" + id + "]");
    }

    public int getId() {
        return id;
    }

    /**
     * @since 4.4
     */
    public int getWeight() {
        return weight;
    }
}
