package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * Thrown when an event listener cancels the {@link PullRequestOpenRequestedEvent event}
 * raised before a {@link PullRequest pull request} is opened.
 *
 * @see PullRequestService#create(String, String, java.util.Set, Repository, String, Repository, String)
 */
public class PullRequestOpenCanceledException extends RequestCanceledException {

    public PullRequestOpenCanceledException(@Nonnull KeyedMessage message,
                                            @Nonnull List<KeyedMessage> cancelMessages) {
        super(message, cancelMessages);
    }
}
