package com.atlassian.bitbucket.pull;

/**
 * Enumerates the possible {@link PullRequestMergeability#getOutcome() outcomes} for attempting to merge a pull request.
 *
 * @since 4.10
 */
public enum PullRequestMergeOutcome {

    /**
     * Indicates the two branches on the {@link PullRequest pull request} merged without conflicts.
     */
    CLEAN(true),
    /**
     * Indicates the two branches on the {@link PullRequest pull request} were merged but conflicts were encountered.
     */
    CONFLICTED(false),
    /**
     * Indicates the system is unable to determine the mergeability of the {@link PullRequest pull request}.
     */
    UNKNOWN(true);

    private final boolean mergeable;

    PullRequestMergeOutcome(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public boolean isMergeable() {
        return mergeable;
    }
}
