package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.commit.Commit;

import javax.annotation.Nullable;

/**
 * A {@link PullRequestActivity} representing when the pull request was merged.
 * <p>
 * Note that merging pull requests is delegated to the SCM implementation, which might support multiple strategies for
 * merging the changes into the target branch. As such the type of the merge {@link #getCommit() commit} should not
 * be assumed.
 * <p>
 * Also note that the merge {@link #getCommit() commit} can be {@code null} if the pull request was merged remotely
 * and pushed rather than being merged via the UI or REST.
 *
 * @see PullRequestActivityType#MERGE
 */
public interface PullRequestMergeActivity extends PullRequestActivity {

    /**
     * @return the merge commit, which may be {@code null} if the pull request was merged remotely
     */
    @Nullable
    Commit getCommit();
}
