package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.13
 */
public class InvalidPullRequestParticipantsException extends InvalidPullRequestParticipantException {

    private static final long serialVersionUID = 1L;

    private final Map<String, KeyedMessage> errorsByParticipantName;
    private final Set<ApplicationUser> validParticipants;

    public InvalidPullRequestParticipantsException(@Nonnull KeyedMessage message, @Nullable PullRequestRole role,
                                                   @Nonnull Map<String, KeyedMessage> errorsByParticipantName,
                                                   @Nonnull Set<ApplicationUser> validParticipants) {
        super(message, role);

        this.errorsByParticipantName = Collections.unmodifiableMap(
                requireNonNull(errorsByParticipantName, "errorsByParticipantName"));
        this.validParticipants = Collections.unmodifiableSet(requireNonNull(validParticipants, "validParticipants"));
    }

    @Nonnull
    public Map<String, KeyedMessage> getErrorsByParticipantName() {
        return errorsByParticipantName;
    }

    @Nonnull
    public Set<ApplicationUser> getValidParticipants() {
        return validParticipants;
    }
}
