package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Indicates an operation to mutate particulars of an existing pull request participant or an operation to add a participant
 * to a pull request is invalid.
 */
public class InvalidPullRequestParticipantException extends IntegrityException {

    private static final long serialVersionUID = 1L;

    private final PullRequestRole role;

    public InvalidPullRequestParticipantException(@Nonnull KeyedMessage message, @Nullable PullRequestRole role) {
        super(message);

        this.role = role;
    }

    @Nullable
    public PullRequestRole getRole() {
        return role;
    }
}