package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Thrown when an operation fails because the {@link PullRequest pull request} is not in the expected
 * {@link PullRequestState state}. For example, this exception might be thrown to indicate a pull request
 * cannot be merged because it has already been declined.
 */
public class IllegalPullRequestStateException extends IllegalEntityStateException {

    public IllegalPullRequestStateException(KeyedMessage message) {
        super(message);
    }
}
