package com.atlassian.bitbucket.migration.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when an Data Center Migration import has been started.
 *
 * @since 5.13
 */
@AsynchronousPreferred
@EventName("stash.migration.import.start")
public class MigrationImportStartedEvent extends AbstractInstanceMigrationEvent {

    public MigrationImportStartedEvent(@Nonnull Object source, @Nonnull Job job) {
        super(source, job);
    }
}
