package com.atlassian.bitbucket.markup;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Indicates a fatal exception occurred rendering markup. This generally happens due to I/O errors,
 * rather than actual markup problems, but it could be caused by either.
 */
public class RenderException extends ServiceException {

    public RenderException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public RenderException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
