package com.atlassian.bitbucket.markup;

import javax.annotation.Nonnull;
import java.io.Reader;

/**
 * Renders content to markup using a pipeline of handlers, such as updating mentions and linking to Jira issues.
 */
public interface MarkupService {

    /**
     * Renders a given string into HTML.
     *
     * @param content       that should be the standard markup type
     * @param renderContext which contains data for rendering in this context
     * @return an HTML string
     * @throws RenderException when there an error rendering the markup
     */
    @Nonnull
    String render(@Nonnull String content, @Nonnull RenderContext renderContext) throws RenderException;

    /**
     * Streams a given string into HTML, appending the results to a given writer.
     *
     * @param reader       that should be the standard markup type
     * @param writer       for streaming the results
     * @param renderContext which contains data for rendering in this context
     * @throws RenderException when there an error streaming the markup
     */
    void stream(@Nonnull Reader reader, @Nonnull Appendable writer, @Nonnull RenderContext renderContext) throws RenderException;
}
