package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates the backing mail queue is full and the mail message cannot be accepted
 * Regarding logging of instances of this exception, see {@link MailException}.
 */
public class MailQueueFullException extends MailException {

    public MailQueueFullException(KeyedMessage message, Throwable cause) {
        super(message, cause);
    }

    public MailQueueFullException(KeyedMessage message) {
        super(message);
    }
}
