package com.atlassian.bitbucket.license;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Indicates that the requested operation would breach an internally enforced limit or policy, defined to
 * ensure that the system operates within defined parameters.
 * <p>
 * See the <a href="https://confluence.atlassian.com/display/BitbucketServer/Scaling+Bitbucket+Server">scaling documentation</a> for
 * more details.
 */
public class LimitExceededException extends ServiceException {

    public LimitExceededException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
