package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.validation.ArgumentValidationException;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.12
 */
public class InvalidLabelException extends ArgumentValidationException {

    private final String labelName;

    public InvalidLabelException(@Nonnull KeyedMessage message, @Nonnull String labelName) {
        super(message);
        this.labelName = requireNonNull(labelName, "labelName");
    }

    @Nonnull
    public String getLabelName() {
        return labelName;
    }
}
