package com.atlassian.bitbucket.i18n;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class KeyedMessage {

    private final String key;
    private final String localisedMessage;
    private final String rootMessage;

    public KeyedMessage(@Nonnull String key, @Nonnull String localisedMessage, @Nonnull String rootMessage) {
        this.key = requireNonNull(key, "key");
        this.localisedMessage = requireNonNull(localisedMessage, "localisedMessage");
        this.rootMessage = requireNonNull(rootMessage, "rootMessage");
    }

    @Nonnull
    public String getKey() {
        return key;
    }

    @Nonnull
    public String getLocalisedMessage() {
        return localisedMessage;
    }

    @Nonnull
    public String getRootMessage() {
        return rootMessage;
    }
}