package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.ScopeType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Set;

/**
 * Contains the static (ie non-repository specific) details of a repository hook.
 */
public interface RepositoryHookDetails {

    /**
     * @return The unique key of this hook, which will be in the form {@code group-id.plugin-id:module-key}
     */
    @Nonnull
    String getKey();

    /**
     * @return The human-readable name of this hook
     */
    @Nonnull
    String getName();

    /**
     * @return The type of hook (ie pre or post receive)
     */
    @Nonnull
    RepositoryHookType getType();

    /**
     * @return The optional description of his hook, or {@code null}
     */
    @Nullable
    String getDescription();

    /**
     * @return The version of this hook (ie the plugin version)
     */
    @Nonnull
    String getVersion();

    /**
     * @return The optional configuration form key if provided, or {@code null}
     */
    @Nullable
    String getConfigFormKey();

    /**
     * @return The scopes at which this hook can be configured
     * @since 5.2
     */
    @Nonnull
    Set<ScopeType> getSupportedScopes();
}
