package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;

import javax.annotation.Nonnull;

/**
 * Request object used for {@link RepositoryHookService#getSettings(GetRepositoryHookSettingsRequest) retrieving settings for a repository hook}.
 *
 * @since 5.2
 */
public class GetRepositoryHookSettingsRequest extends AbstractUpdateRepositoryHookRequest {

    private GetRepositoryHookSettingsRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder {

        public Builder(@Nonnull Scope scope, @Nonnull String hookKey) {
            super(scope, hookKey);
        }

        @Nonnull
        public GetRepositoryHookSettingsRequest build() {
            return new GetRepositoryHookSettingsRequest(this);
        }
    }
}
