package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.setting.Settings;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/**
 * Request object used for {@link RepositoryHookService#enable(EnableRepositoryHookRequest) enabling a repository hook}.
 *
 * @since 5.2
 */
public class EnableRepositoryHookRequest extends AbstractUpdateRepositoryHookRequest {

    private final Settings settings;

    private EnableRepositoryHookRequest(Builder builder) {
        super(builder);
        settings = builder.settings;
    }

    @Nonnull
    public Optional<Settings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public static class Builder extends AbstractBuilder {

        private Settings settings;

        public Builder(@Nonnull Scope scope, @Nonnull String hookKey) {
            super(scope, hookKey);
        }

        @Nonnull
        public EnableRepositoryHookRequest build() {
            return new EnableRepositoryHookRequest(this);
        }

        @Nonnull
        public Builder settings(@Nonnull Settings value) {
            settings = requireNonNull(value, "settings");
            return this;
        }
    }
}
