package com.atlassian.bitbucket.hook;

import javax.annotation.Nonnull;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Optional;

/**
 * Describes an SCM hook invocation, providing access to the output and error streams of the remote client
 *
 * @since 5.0
 */
public interface ScmHookDetails {

    /**
     * @return a {@link PrintWriter} that can be used to output error messages to the remote client.
     */
    @Nonnull
    PrintWriter err();

    /**
     * @return the environment variables set by the SCM when the hook was run
     * @deprecated in 5.10 for removal <i>without replacement</i> in 6.0. <i>Starting in 6.0 add-ons will no longer
     *             be allowed to directly access repository data on disk.</i> Instead, they will be required to use
     *             commands, command builders and other API services to interact with repositories. Since environment
     *             variables may reference paths on disk, they will no longer be exposed.
     */
    @Deprecated
    @Nonnull
    Map<String, String> getEnvironment();

    /**
     * @return the hook-identifier provided by the SCM hook callback
     */
    @Nonnull
    Optional<String> getHookName();

    /**
     * @return a {@link PrintWriter} that can be used to output messages to the remote client.
     */
    @Nonnull
    PrintWriter out();
}
