package com.atlassian.bitbucket.hook;

import javax.annotation.Nonnull;
import java.io.PrintWriter;

/**
 * Provides methods to write to an scm client's stdout and stderr streams.
 */
public interface HookResponse {

    /**
     * @return a {@link PrintWriter} that can be used to output error messages to the remote client.
     */
    @Nonnull
    PrintWriter err();

    /**
     * @return a {@link PrintWriter} that can be used to output messages to the remote client.
     */
    @Nonnull
    PrintWriter out();
}
