package com.atlassian.bitbucket.hook;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Represents a SCM hook request. Hooks call back into the application providing:
 * <ul>
 *     <li>the hook identifier (e.g. git-pre-receive)</li>
 *     <li>the environment variables set by the SCM</li>
 *     <li>any arguments provided to the hook</li>
 *     <li>any remaining input</li>
 * </ul>
 */
public interface HookRequest {

    /**
     * @return the list of arguments provided by the SCM hook callback
     */
    @Nonnull
    List<String> getArguments();

    /**
     * @return the environment variables set by the SCM when the hook was run
     * @since 4.13
     */
    @Nonnull
    default Map<String, String> getEnvironment() {
        return Collections.emptyMap();
    }

    /**
     * @return the hook-identifier provided by the SCM hook callback
     */
    @Nullable
    String getHookName();

    /**
     * @return the remainder of the input provided by the SCM hook callback
     */
    @Nonnull
    CharSequence getInput();
}
