package com.atlassian.bitbucket.event.throttle;

import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event raised when an attempt to acquire a {@link Ticket Ticket} from a given bucket
 * is rejected by the {@link ThrottleService ThrottleService}.
 * <p>
 * This event is internally audited with a LOW priority.
 */
@AsynchronousPreferred
public class TicketRejectedEvent extends TicketEvent {

    public TicketRejectedEvent(@Nonnull Object source, @Nonnull String resourceName) {
        super(source, resourceName);
    }
}
