package com.atlassian.bitbucket.event.throttle;

import com.atlassian.bitbucket.throttle.ThrottleService;
import com.atlassian.bitbucket.throttle.Ticket;
import com.atlassian.bitbucket.throttle.TicketContext;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Event raised when a {@link Ticket Ticket} is acquired from a given bucket in the
 * {@link ThrottleService ThrottleService}.
 */
@AsynchronousPreferred
public class TicketAcquiredEvent extends TicketEvent {

    private final TicketContext ticketContext;

    public TicketAcquiredEvent(@Nonnull Object source, @Nonnull TicketContext ticketContext) {
        super(source, ticketContext.getResourceName());

        this.ticketContext = requireNonNull(ticketContext, "ticketContext");
    }

    /**
     * @return context for the acquired ticket
     */
    @Nonnull
    public TicketContext getTicketContext() {
        return ticketContext;
    }
}
