package com.atlassian.bitbucket.event.tag;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * An event that is raised when a tag is created using the UI or REST. Tags
 * created by pushing will not trigger this event.
 * <p>
 * Listeners that are interested in all repository changes should listen for
 * {@link RepositoryRefsChangedEvent}s instead.
 */
@AsynchronousPreferred
@EventName("stash.tag.created")
public class TagCreatedEvent extends TagChangedEvent {

    public TagCreatedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Tag tag) {
        super(source, repository, tag, new SimpleRefChange.Builder()
                .fromHash(EMPTY_HASH)
                .to(tag)
                .type(RefChangeType.ADD)
                .build());
    }
}
