package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when an SCM client pulls from a repository. A more specific {@link RepositoryCloneEvent} is raised if the
 * pull clones the entire repository. This event will be raised directly for <i>incremental</i> pulls, such as when
 * using {@code git fetch}.
 * <p>
 * This event is internally audited with a LOW priority.
 */
@AsynchronousPreferred
@EventName("stash.repository.pulled")
public class RepositoryPullEvent extends RepositoryEvent {

    public RepositoryPullEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
