package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a repository is forked successfully.
 * <p>
 * The {@link #getRepository() repository} attached to the event is the fork that was created. Its
 * {@link Repository#getOrigin() origin} provides the repository that was forked to create it. Note that forks can be
 * created in the same project as their origin or in a different one, so the {@link Repository#getProject() project}s
 * for the fork and its origin may or may not be the same.
 *
 * @see RepositoryService#fork(RepositoryForkRequest)
 */
@AsynchronousPreferred
@EventName("stash.repository.forked")
public class RepositoryForkedEvent extends RepositoryCreatedEvent {

    public RepositoryForkedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
