package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base class for all events related to repositories: pushes, pulls, merge operations, etc.
 * <p>
 * This event is internally audited with a MEDIUM priority.
 */
public abstract class RepositoryEvent extends ApplicationEvent {

    private final Repository repository;

    public RepositoryEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source);

        this.repository = checkNotNull(repository, "repository");
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
