package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.collect.ImmutableSet;

import javax.annotation.Nonnull;

import static java.util.Collections.emptyList;
import static java.util.Objects.requireNonNull;

/**
 * Event that is raised when a repository is deleted
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.deleted")
public class RepositoryDeletedEvent extends RepositoryEvent {

    private final Iterable<Integer> forkIds;

    /**
     * @deprecated in 5.6 for removal in 6.0
     */
    @Deprecated
    public RepositoryDeletedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        this(source, repository, emptyList());
    }

    /**
     * @since 5.6
     */
    public RepositoryDeletedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                  @Nonnull Iterable<Integer> forkIds) {
        super(source, repository);

        this.forkIds = ImmutableSet.copyOf(requireNonNull(forkIds, "forkIds"));
    }

    /**
     * @return the IDs of all repositories that are forks of the repository being deleted
     * @since 5.6
     */
    @Nonnull
    public Iterable<Integer> getForkIds() {
        return forkIds;
    }
}
