package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a repository is accessed by a user. This event is currently only raised when users
 * hit a repository page via the UI.
 * <p>
 * This event is internally audited with a LOW priority.
 */
public class RepositoryAccessedEvent extends RepositoryEvent {

    public RepositoryAccessedEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
