package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A base class for ref change request events
 *
 * @deprecated in 5.0 for removal in 6.0. Listeners for {@code RefChangeRequestEvent} or one of its subclasses should
 *             implement a {@code PreRepositoryHook} and check the
 *             {@link com.atlassian.bitbucket.hook.repository.RepositoryHookRequest request} for the appropriate
 *             {@link com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger trigger(s)}
 */
@Deprecated
public abstract class RefChangeRequestedEvent extends ApplicationEvent implements CancelableEvent {

    private final CancelState cancelState;
    private final Repository repository;

    public RefChangeRequestedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                   @Nonnull CancelState cancelState) {
        super(source);

        this.cancelState = requireNonNull(cancelState, "cancelState");
        this.repository = requireNonNull(repository, "repository");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        cancelState.cancel(message);
    }

    @Nonnull
    public Repository getRepository() {
        return repository;
    }

    @Override
    public boolean isCanceled() {
        return cancelState.isCanceled();
    }
}
