package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a merge activity is created for a pull request.
 */
@AsynchronousPreferred
public class PullRequestMergeActivityEvent extends PullRequestActivityEvent {

    public PullRequestMergeActivityEvent(@Nonnull Object source, @Nonnull PullRequestMergeActivity activity) {
        super(source, activity);
    }

    @Nonnull
    @Override
    public PullRequestMergeActivity getActivity() {
        return (PullRequestMergeActivity) super.getActivity();
    }
}
