package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is added on a commit in a pull request.
 *
 * @deprecated in 5.4 for removal in 6.0. Listen for {@link PullRequestCommentAddedEvent} instead.
 *             {@link com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType#COMMIT Commit} and
 *             {@link com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType#RANGE range} comments
 *             can be identified via the {@link Comment#getThread() thread's} associated
 *             {@link CommentThread#getAnchor() anchor} if present; otherwise, it's a general comment
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.commit.comment.added")
@Deprecated
public class PullRequestCommitCommentAddedEvent extends PullRequestCommentAddedEvent {

    public PullRequestCommitCommentAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                              @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, pullRequest, comment, parent);
    }
}
