package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is replied to on a pull request.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.comment.replied")
public class PullRequestCommentRepliedEvent extends PullRequestCommentEvent {

    public PullRequestCommentRepliedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                          @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, pullRequest, comment, parent, CommentAction.REPLIED);
    }
}
