package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is added on a pull request.
 *
 * This does not include replies, which raise a {@link PullRequestCommentRepliedEvent}.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.comment.added")
public class PullRequestCommentAddedEvent extends PullRequestCommentEvent {

    public PullRequestCommentAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                        @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, pullRequest, comment, parent, CommentAction.ADDED);
    }
}
