package com.atlassian.bitbucket.event.project;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a project has been successfully updated.
 * <p>
 * When this event is raised, the project's persisted state has been updated and committed, so {@link #getProject()}
 * matches the {@link #getNewValue() new values}.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.project.updated")
public class ProjectModifiedEvent extends AbstractProjectModificationEvent {

    public ProjectModifiedEvent(@Nonnull Object source, @Nonnull Project oldValue, @Nonnull Project newValue) {
        super(source, newValue, oldValue, newValue);
    }
}
