package com.atlassian.bitbucket.event.project;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.project.Project;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base class for all project related events.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public abstract class ProjectEvent extends ApplicationEvent {

    private final Project project;

    protected ProjectEvent(@Nonnull Object source, @Nonnull Project project) {
        super(source);

        this.project = checkNotNull(project, "project");
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }
}
