package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Strings;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Base event signalling repository permission changes.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public abstract class RepositoryPermissionEvent extends PermissionEvent {

    private final Repository repository;

    protected RepositoryPermissionEvent(Object source, Permission permission, Repository repository,
                                        String affectedGroup, ApplicationUser affectedUser) {
        super(source, permission, affectedGroup, affectedUser);

        checkArgument(Strings.isNullOrEmpty(affectedGroup) ^ affectedUser == null,
                "Either a user or group can be affected, not both or neither. user=%s, group=%s", affectedUser, affectedGroup);
        checkArgument(permission.isResource(Repository.class), "Require a repository permission");
        this.repository = checkNotNull(repository, "repository");
    }

    public Repository getRepository() {
        return repository;
    }
}
