package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * This event signals that a {@link Repository} has failed to synchronize on a mirror.
 *
 * @since 5.0
 */
public class RepositoryMirrorSynchronizationFailedEvent extends AbstractRepositoryMirrorEvent {

    public RepositoryMirrorSynchronizationFailedEvent(@Nonnull Object source, @Nonnull String mirrorServerId,
                                                      @Nonnull Repository repository) {
        super(source, mirrorServerId, repository);
    }
}