package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base class for {@link Repository} events that have been raised on a mirror.
 * <p>
 * This class does not extend {@link RepositoryEvent} because events derived from this class relate to
 * mirrored repositories while the {@link RepositoryEvent} hierarchy relates to local repositories.
 *
 * @since 5.0
 */
public class AbstractRepositoryMirrorEvent extends ApplicationEvent implements RepositoryMirrorEvent {

    private final String mirrorServerId;
    private final Repository repository;

    public AbstractRepositoryMirrorEvent(@Nonnull Object source, @Nonnull String mirrorServerId,
                                         @Nonnull Repository repository) {
        super(source);
        this.mirrorServerId = requireNonNull(mirrorServerId, "mirrorServerId");
        this.repository = requireNonNull(repository, "repository");
    }

    @Nonnull
    @Override
    public String getMirrorServerId() {
        return mirrorServerId;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}