package com.atlassian.bitbucket.event.hook;


import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Fired when a repository hook's settings are changed.
 * <p>
 * This event is internally audited with a MEDIUM priority.
 */
@AsynchronousPreferred
@TransactionAware
@EventName("stash.repository.hook.settings.changed")
public class RepositoryHookSettingsChangedEvent extends RepositoryHookEvent {

    private final Settings settings;

    /**
     * @deprecated in 5.2 for removal in 6.0. Use {@link #RepositoryHookSettingsChangedEvent(Object, Scope, String, Settings)} instead.
     */
    @Deprecated
    public RepositoryHookSettingsChangedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull String hookKey, @Nonnull Settings settings) {
        this(source, Scopes.repository(repository), hookKey, settings);
    }

    /**
     * @since 5.2
     */
    public RepositoryHookSettingsChangedEvent(@Nonnull Object source, @Nonnull Scope scope, @Nonnull String repositoryHookKey, @Nonnull Settings settings) {
        super(source, repositoryHookKey, scope);
        this.settings = requireNonNull(settings, "settings");
    }

    @Nonnull
    public Settings getSettings() {
        return settings;
    }

}
