package com.atlassian.bitbucket.event.hook;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Children of this event are fired when repository hooks are changed.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
@TransactionAware
public class RepositoryHookEvent extends ApplicationEvent {

    private final String repositoryHookKey;
    private final Scope scope;

    /**
     * @deprecated in 5.2 for removal in 6.0. Use {@link #RepositoryHookEvent(Object, String, Scope)} instead.
     */
    @Deprecated
    protected RepositoryHookEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull String repositoryHookKey) {
        this(source, repositoryHookKey, Scopes.repository(repository));
    }

    /**
     * @since 5.2
     */
    protected RepositoryHookEvent(@Nonnull Object source, @Nonnull String repositoryHookKey, @Nonnull Scope scope) {
        super(source);
        this.repositoryHookKey = requireNonNull(repositoryHookKey, "repositoryHookKey");
        this.scope = requireNonNull(scope, "scope");
    }

    /**
     * @deprecated in 5.2 for removal in 6.0. Use {@link #getScope()} instead. This will return {@code null} when
     * {@link RepositoryHookEvent} is fired for any {@link Scope} other than {@link RepositoryScope}
     */
    @Deprecated
    @Nullable
    public Repository getRepository() {
        return scope.accept(new ScopeVisitor<Repository>() {
            @Override
            public Repository visit(@Nonnull RepositoryScope scope) {
                return scope.getRepository();
            }
        });
    }

    @Nonnull
    public String getRepositoryHookKey() {
        return repositoryHookKey;
    }

    /**
     * @since 5.2
     */
    @Nonnull
    public Scope getScope() {
        return scope;
    }
}
